# Apptorium Code Formatting Rules

Poniższe zasady opisują formatowanie kodu Swift zgodne ze stylem widocznym w AptApp i AptUtilities. Stosuj je we wszystkich modułach Apptorium.

## 1. Wcięcia i białe znaki
- Wcięcia: 4 spacje, bez tabów.
- Spacje wokół operatorów binarnych (`=`, `==`, `+`, `&&`, itp.).
- Spacja po przecinku w listach argumentów i kolekcjach.
- Nie używaj pustych linii „dla ozdoby” — tylko do separacji logicznych bloków.
- Limit długości linii: **80 znaków**. Jeśli linia jest dłuższa, łam ją zgodnie z zasadami w sekcjach 5–7.

## 2. Klamry i bloki (krytyczne)
- Otwierająca klamra w tej samej linii co deklaracja lub instrukcja sterująca (K&R).
- Zamykająca klamra zawsze w osobnej linii.
- `else`/`catch` w tej samej linii co zamykająca klamra poprzedniego bloku.
- **Kategoryczny zakaz jednowierszowych bloków.** Dotyczy `guard`, `if`, `else`, `while`, `for`, `do`, `switch` (blok), `defer` oraz bloków `closure`.

NIE:
```swift
guard condition else { return nil }
```

TAK:
```swift
guard condition else {
    return nil
}
```

## 3. Puste linie między blokami `{}` (obowiązkowe)
- **Zawsze** oddzielaj sąsiednie bloki `{}` jedną pustą linią.
- Dotyczy to sekwencji `if`/`for`/`while`/`guard`/`switch`/`do`/`defer` oraz dowolnych bloków w funkcji.
- **Nie** wstawiaj pustej linii między `}` a `else`/`catch` (to jeden blok logiczny).

Przykład:
```swift
func aa() {
    if conditionA {
        // ...
    }

    if conditionB {
        // ...
    }

    aaa()
    bbbb()

    if conditionC {
        // ...
    }
}
```

## 4. `guard` i wczesne wyjścia
- `guard` zawsze wieloliniowo.
- `return`/`throw`/`break` zawsze w osobnej linii.
- Po bloku `guard` zostaw pustą linię przed dalszą logiką.

## 5. Instrukcje warunkowe i pętle
- Warunki wieloliniowe zapisuj z nową linią po `(` lub po operatorach logicznych.
- Dla złożonych warunków preferuj łamanie linii zamiast długiej jednej linii.

Przykład:
```swift
if isReady &&
   isAuthorized &&
   hasNetwork {
    // ...
}
```

## 6. Zawijanie linii i lista parametrów
- Jeśli lista parametrów nie mieści się w jednej linii, każdy parametr w osobnej linii.
- Nawias zamykający w osobnej linii, bez przecinka po ostatnim argumencie.
- Dotyczy zarówno deklaracji funkcji/initializerów, jak i wywołań.

Przykład:
```swift
public init(
    expiryDate: Date,
    downloadURL: URL,
    checkingInterval: TimeInterval = 3600
) {
    self.expiryDate = expiryDate
    self.downloadURL = downloadURL
    self.interval = checkingInterval
}
```

## 7. Łańcuchy wywołań (SwiftUI i inne)
- Długie łańcuchy wywołań zapisuj kaskadowo, po jednej metodzie na linię.
- Kropka rozpoczyna kolejną linię.

Przykład:
```swift
Text(message)
    .font(.callout.weight(.semibold))
    .multilineTextAlignment(.center)
```

## 8. `switch`
- `case` i `default` w osobnych liniach.
- Krótkie instrukcje po dwukropku mogą zostać w jednej linii (bez dodatkowych klamer), np. `case .export: self = .exporting`.
- Dla bardziej rozbudowanej logiki — pełny blok wieloliniowy.

## 9. Kolekcje i literały
- Kolekcje wieloliniowe: jeden element na linię.
- Preferowany zapis typów słowników: `[Key: Value]` (bez spacji wokół `:`).
- W mapowaniach i filtrach preferuj jawne nazwy `key`, `value` zamiast nieczytelnych skrótów.

## 10. Atrybuty i dyrektywy kompilatora
- Atrybuty (`@available`, `@objc`, `@IBAction`) w osobnych liniach nad deklaracją.
- Dyrektywy kompilatora (`#if os(...)`) na osobnych liniach, otaczane pustą linią, gdy oddzielają sekcje.

## 11. Układ pliku
- Nagłówek pliku (komentarz Xcode) na górze.
- `import` bez pustych linii pomiędzy kolejnymi importami.
- Kolejność sekcji w typie: właściwości → init → publiczne metody → prywatne metody → pomocnicze typy.

## 12. Komentarze i dokumentacja
- Komentarze dokumentacyjne: `///` dla publicznych API.
- Komentarze blokowe tylko gdy naprawdę potrzebne; preferuj krótkie, rzeczowe opisy.

## 13. Czytelność i nazewnictwo
- **Nie używaj skrótów w nazwach.** Nazwy mają być pełne i zrozumiałe.
- Preferuj opisowe nazwy zmiennych, funkcji i typów zamiast jednowyrazowych skrótów.
- Jednoliterowe nazwy dopuszczalne wyłącznie w bardzo krótkich, lokalnych kontekstach (np. proste pętle), jeśli znaczenie jest oczywiste.

## 14. Struktura kodu
- Kod ma być czytelny i podzielony na sensowne jednostki: funkcje, klasy, struktury, rozszerzenia.
- Funkcje powinny realizować jedną odpowiedzialność i być możliwie krótkie.
- Większe bloki logiki rozbijaj na prywatne metody pomocnicze.
- Wszelkie struktury, klasy, protokoły powinny być w osobnych plikach.
- Katalogi: Views (z odpowiednimi działami, np. Main Window, Settings; z logicznymi podkatalogami. Jeśli jakiś widok potrzebuje własnych podwidoków, to katalog Subviews można w nim umieścić), Data, Core
